package aln.SpawnCommands;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class CommandSpawnMinus implements ICommand {

  @Override
  public int compareTo(Object arg0) {
    return 0;
  }

  @Override
  public String getCommandName() {
    //return "spawn-";
	return Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn-");
  }

  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+ Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn-") +" myplace  Removes 'myplace' from your named locations list.";
  }

  @Override
  public List getCommandAliases() {
	//return Arrays.asList(new String[] {"home"});
    return Arrays.asList(new String[] { });
  }

  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      if ( player.worldObj.isRemote ) { return; }
      
      SpawnCommands.loadCommandPermissionsConfig();
      SpawnCommands.loadMiscConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      if ( (params.length != 1) || (params[0].equalsIgnoreCase("help")) ) { SpawnCommands.showHelp(player); return; }
      
      // validate named location name format. all letters and numbers and minus
      boolean isSharedName = false;
      if ( params[0].substring(0,1).equals("@") ) { // if it starts with "@"
        isSharedName = true;
        params[0] = params[0].substring(1); // remove the "@"
        if ( params[0].length() == 0 ) { return; }
      }
      String theName = params[0];
      theName = theName.replaceAll("[^a-zA-Z0-9\\-]","");
      if ( ! theName.contentEquals(params[0]) ) { Do.Say(player, "Named locations must use only numbers, letters, and '-'"); return; }
      theName = theName.toLowerCase();
      
      if ( isSharedName ) { 
        // "no" and "op" and "enable" are handled here. "all" is the default.
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-@sharedlocation").equalsIgnoreCase("no") ) 
        { Do.Say(player,"Removing a shared §e@§Rname is not permitted. See config files."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-@sharedlocation").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
        { Do.Say(player,"Removing a shared §e@§Rname is an op only command.  You are not an op."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-@sharedlocation").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
        { Do.Say(player,"Removing a shared §e@§Rname is an advanced command and is not enabled for SpawnCommands."); return; }
      }
      
      if ( ! isSharedName ) {
        // "no" and "op" and "enable" are handled here. "all" is the default.
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-name").equalsIgnoreCase("no") ) 
        { Do.Say(player,"Removing a named location is not permitted. See config files."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-name").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
        { Do.Say(player,"Removing a named location is an op only command.  You are not an op."); return; }
        if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn-name").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
        { Do.Say(player,"Removing a named location is an advanced command and is not enabled for SpawnCommands."); return; }
      }
      
      String filePathAndName;
      if ( isSharedName ) 
      { filePathAndName = SpawnCommands.configBasePath+SpawnCommands.folderSharedNamedLocations+"/"+theName; }
      else
      //{ filePathAndName = SpawnCommands.configBasePath+player.getName()+"/"+theName; } // mc1.8
      { filePathAndName = SpawnCommands.configBasePath+player.getGameProfile().getName()+"/"+theName; } // mc1.7.10
      if ( ! Do.fileExists(filePathAndName) ) 
      { Do.Say(player, "Named location '"+ (isSharedName ? "@" : "") + theName +"' does not exist."); return; }
      File theFile = new File(filePathAndName);
      if ( ! theFile.delete() ) { Do.Err(player, "CommandSpawnMinus: Could not remove the file for the location '"+ (isSharedName ? "@" : "") + theName +"'."); return; }
      Do.Say(player, (isSharedName ? "@" : "") + theName + " location was removed.");
      return;
    } // end is player
    return;
   }

  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
